<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Classe che definisce le cartelle di Geecom Doc
    */

    class Cartella {
        private $db;
        private $id;
        private $cartellaMadre;
        private $nome;
        private $descrizione;
        private $dataCreazione;
        
        function __construct($db, $id) {
            $this->db = $db;
            $this->id = $id;
            $this->cartellaMadre = 0;
            $this->nome          = "";
            $this->percorso      = "";
            $this->dataCreazione = "";
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            $queryControlloTagEsistente ="SELECT * FROM geecD_cartelle WHERE nome LIKE '$this->nome' AND cartellaMadre='$this->cartellaMadre'";
            $ris = $this->db->eseguiQueryLettura($queryControlloTagEsistente);
            if($ris->num_rows == 0) {
                $query = "INSERT INTO geecD_cartelle VALUES(NULL,'$this->cartellaMadre','$this->nome','$this->descrizione','$dataCreazione')";
                $this->id = $this->db->eseguiQueryCreazione($query);
                return $this->id;
            }
            else {
                return -1;
            }
        }

        function modifica() {
            $query = "UPDATE geecD_cartelle SET nome='$this->nome', descrizione = '$this->descrizione' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }

        function rinomina() {
            $query = "UPDATE geecD_cartelle SET nome='$this->nome' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function sposta($idCartella) {
            $query = "UPDATE geecD_cartelle SET cartellaMadre='$idCartella' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function spostaSelezionati($cartellaDestinazione,$stringaIdCartelle,$stringaIdDocumenti) {
            $arrayIdCartelle = explode("-",$stringaIdCartelle);
            
            foreach($arrayIdCartelle as $idCartella) {
                if(is_numeric($idCartella)) {                
                    $queryEliminazioneVersioniDocumento = "UPDATE geecD_cartelle SET cartellaMadre=$cartellaDestinazione  WHERE id=$idCartella";
                    $this->db->eseguiQueryLettura($queryEliminazioneVersioniDocumento);
                }
            }
            
            $arrayIdDocumenti = explode("-",$stringaIdDocumenti);
            foreach($arrayIdDocumenti as $idDocumento) {
                if(is_numeric($idDocumento)) {
                    $queryDocumentiDaEliminare = "UPDATE geecD_documenti SET cartella=$cartellaDestinazione WHERE id=$idDocumento";
                    $this->db->eseguiQueryScrittura($queryDocumentiDaEliminare);
                }
            }
        }
        
        function spostaContenuto($idCartella) {
            $queryEliminazioneVersioniDocumento = "UPDATE geecD_cartelle SET cartellaMadre=$idCartella  WHERE cartellaMadre=$this->id";
            $this->db->eseguiQueryLettura($queryEliminazioneVersioniDocumento);
            
            $queryDocumentiDaEliminare = "UPDATE geecD_documenti SET cartella=$idCartella WHERE cartella=$this->id";
            $this->db->eseguiQueryScrittura($queryDocumentiDaEliminare);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_cartelle",$this->id);
        }

        function eliminaSelezionati($stringaIdCartelle,$stringaIdDocumenti) {
            $arrayIdCartelle = explode("-",$stringaIdCartelle);
            foreach($arrayIdCartelle as $idCartella) {
                if(is_numeric($idCartella)) {                
                    $this->db->eseguiQueryCancellazione("geecD_cartelle",$idCartella);
                }
            }
            
            $arrayIdDocumenti = explode("-",$stringaIdDocumenti);
            foreach($arrayIdDocumenti as $idDocumento) {
                if(is_numeric($idDocumento)) {
                    $this->db->eseguiQueryCancellazione("geecD_documenti",$idDocumento);
                }
            }
        }
        
        function eliminaContenuto() {
            $queryEliminazioneVersioniDocumento = "DELETE FROM geecD_cartelle WHERE cartellaMadre=$this->id";
            $this->db->eseguiQueryLettura($queryEliminazioneVersioniDocumento);
            
            $queryDocumentiDaEliminare = "SELECT * FROM geecD_documenti WHERE cartella=$this->id";
            $risDocumentiDaEliminare   = $this->db->eseguiQueryLettura($queryDocumentiDaEliminare);
            
            while($documentoDaEliminare = $risDocumentiDaEliminare->fetch_assoc()) {
                $queryEliminazioneVersioniDocumento = "DELETE FROM geecD_versioniDocumento WHERE idDocumento={$documentoDaEliminare["id"]}";
                $this->db->eseguiQueryLettura($queryEliminazioneVersioniDocumento);
                $this->db->eseguiQueryCancellazione("geecD_documenti",$documentoDaEliminare["id"]);
            }
        }
         
        function caricaDatiDalDatabase() {
            $datiCartella = $this->db->leggiSingolaRiga("geecD_cartelle",$this->id);
            $this->datiCartella  = $datiCartella;
            $this->cartellaMadre = $datiCartella["cartellaMadre"];
            $this->nome          = $datiCartella["nome"];
            $this->descrizione   = $datiCartella["descrizione"];
        }
        
        function aggiungiAiPreferiti($idUtente) {
            $query = "INSERT INTO geecD_cartellePreferite VALUES($idUtente,$this->id)";
            $this->db->eseguiQueryCreazione($query);
        }
               
        function rimuoviDaiPreferiti($idUtente) {
            $query = "DELETE FROM geecD_cartellePreferite WHERE idUtente=$idUtente AND idCartella=$this->id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function alberoCartella($cartellaAttuale = 0,$aperto=true, $arrayCartelleMadri = []) {
            
            // nell'array delle cartelle madri viene inserita anche la cartella attuale in modo
            // che verrà mostrata nel sottoalbero
            array_push($arrayCartelleMadri,$cartellaAttuale);
            
            $classeLinkToggle = ($aperto) ? "" : "collapsed";
            $classeDivAlbero  = ($aperto) ? "collapse show" : "collapse";
            ?>
            <div class="dropdownTrigger d-flex align-items-center justify-content-between">
                <a href="dettagliCartella.php?id=<?= $this->id ?>">
                    <?= $this->nome ?>
                </a>
                <a data-toggle="collapse" class="<?= $classeLinkToggle ?>" href="#alberoCartella<?= $this->id ?>">
                </a>
            </div>
            <div class="<?= $classeDivAlbero ?>" id="alberoCartella<?= $this->id ?>">
                <div class="ml-3">
                    <?php 
                        $query = "SELECT * FROM geecD_cartelle WHERE cartellaMadre = $this->id";
                        $risSottoCartelle = $this->db->eseguiQueryLettura($query);
                        while($sottoCartella = $risSottoCartelle->fetch_assoc()) {
                            if(in_array($sottoCartella["id"], $arrayCartelleMadri) || $sottoCartella["id"]==$cartellaAttuale) {
                                $this->stampaSottoAlbero($sottoCartella,true,$arrayCartelleMadri);
                            }
                            else {
                                $this->stampaSottoAlbero($sottoCartella);
                            }
                        }
                    ?>
                </div>
            </div>
            <?php
        }
        
        /*
         * Stampa l'albero della sottocartella passata in input
         */
        function stampaSottoAlbero($cartella,$aperto=false,$arrayCartelleMadri=[]) {
            $queryContenutoCartella = "SELECT * FROM geecD_cartelle WHERE cartellaMadre = {$cartella["id"]}";
            $risContenutoCartella   = $this->db->eseguiQueryLettura($queryContenutoCartella);
            
            $classeToggleDiv      = ($aperto) ? "" : "collapsed";
            $classeDivSottoAlbero = ($aperto) ? "collapse show" : "collapse";
            
            if($risContenutoCartella->num_rows>0) {
                ?>
                <div class="dropdownTrigger d-flex align-items-center justify-content-between">
                    <a href="dettagliCartella.php?id=<?= $cartella["id"] ?>">
                        <?= $cartella["nome"] ?>
                    </a>
                    <a data-toggle="collapse" class="<?= $classeToggleDiv ?>" href="#sottoAlbero<?= $cartella["id"] ?>">
                    </a>
                </div>
                <div class="<?= $classeDivSottoAlbero ?>" id="sottoAlbero<?= $cartella["id"] ?>">
                    <div class="ml-3">
                        <?php
                            while($elementoCartella = $risContenutoCartella->fetch_assoc()) {
                                if(in_array($elementoCartella["id"], $arrayCartelleMadri)) {
                                    $this->stampaSottoAlbero($elementoCartella,true,$arrayCartelleMadri);
                                }
                                else {
                                    ?>
                                    <a href="dettagliCartella.php?id=<?= $elementoCartella["id"] ?>">
                                        <?= $elementoCartella["nome"] ?>
                                    </a>
                                    <?php
                                }
                            }
                        ?>
                    </div>
                </div>
                <?php
            }
            else {
                ?>
                <a href="dettagliCartella.php?id=<?= $cartella["id"] ?>" class=" d-block">
                    <?= $cartella["nome"] ?>
                </a>
                <?php
            }
        }
        
        function stampaBreadcrumbCartella($idCartellaRadice=0) {
            ?>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-xl-0">
                    <?php 
                        $arraySottoCartelle = array();
                        $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$this->datiCartella["cartellaMadre"]);
                        while($datiSottoCartella != null && $datiSottoCartella["id"]>=$idCartellaRadice) {
                            $arraySottoCartelle[count($arraySottoCartelle)] = "<li class=\"breadcrumb-item\"><a href=\"dettagliCartella.php?id={$datiSottoCartella["id"]}\">{$datiSottoCartella["nome"]}</a></li>";
                            if($datiSottoCartella["cartellaMadre"]!=0) {
                                $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$datiSottoCartella["cartellaMadre"]);
                            }
                            else {
                                $datiSottoCartella = null;
                            }
                        }

                        $arraySottoCartelle = array_reverse($arraySottoCartelle);
                        foreach($arraySottoCartelle as $sottoCartella) {
                            echo $sottoCartella;
                        }
                        
                        if($this->datiCartella["cartellaMadre"]>=$idCartellaRadice) {
                            ?>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $this->datiCartella["nome"] ?></li>
                            <?php
                        }
                    ?>
                </ol>
            </nav>
            <?php
        }
        
        function stampaBreadcrumbCartellaModalSpostamento($tipoModal,$idCartellaRadice=0) {
            ?>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-xl-0">
                    <?php 
                        $arraySottoCartelle = array();
                        $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$this->datiCartella["cartellaMadre"]);
                        while($datiSottoCartella != null && $datiSottoCartella["id"]>=$idCartellaRadice) {
                            $arraySottoCartelle[count($arraySottoCartelle)] = "<li class=\"breadcrumb-item\"><a href=\"javascript:void\" onclick=\"caricaElementiModalSpostamento('$tipoModal',{$datiSottoCartella["id"]})\">{$datiSottoCartella["nome"]}</a></li>";
                            if($datiSottoCartella["cartellaMadre"]!=0) {
                                $datiSottoCartella  = $this->db->leggiSingolaRiga("geecD_cartelle",$datiSottoCartella["cartellaMadre"]);
                            }
                            else {
                                $datiSottoCartella = null;
                            }
                        }

                        $arraySottoCartelle = array_reverse($arraySottoCartelle);
                        foreach($arraySottoCartelle as $sottoCartella) {
                            echo $sottoCartella;
                        }
                        
                        if($this->datiCartella["cartellaMadre"]>=$idCartellaRadice) {
                            ?>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $this->datiCartella["nome"] ?></li>
                            <?php
                        }
                    ?>
                </ol>
            </nav>
            <?php
        }
        
        function stampaContenutoCartella($paginaHome,$cerca="",$stampaFormAggiungiCartella = true) {
            $numeroElementi = 0;
                    
            $query       = "SELECT * FROM geecD_cartelle WHERE cartellaMadre = $this->id AND nome LIKE '%$cerca%'";
            $risCartelle = $this->db->eseguiQueryLettura($query);
            $numeroElementi += $risCartelle->num_rows;

            while($cartella = $risCartelle->fetch_assoc()) {
                stampaCartella($this->db, $cartella,$paginaHome);
            }
            
            $query   = "SELECT * FROM geecD_documenti WHERE cartella = $this->id AND nome LIKE '%$cerca%'";
            $risDocumenti = $this->db->eseguiQueryLettura($query);
            $numeroElementi += $risDocumenti->num_rows;
            
            while($documento = $risDocumenti->fetch_assoc()) {
                stampaDocumento($this->db,$documento);
            }
            
            if($stampaFormAggiungiCartella) {
                ?>
                    <div class="col">
                        <input type="text" id="campoCartellaMadre1" class="d-none" value="<?= $this->id ?>">
                        <input type="text" id="campoCreaCartella1" class="form-control rounded-top">
                        <button type="button" class="btn btn-primary btn-block rounded-bottom" onclick="creaCartella('campoCreaCartella1','campoCartellaMadre1')">Nuova cartella<i class="fas fa-folder-plus ml-2"></i></button>
                    </div>
                <?php
            }
        }
        
        function stampaHtmlCartella() {
            $datiEtichetta   = $this->db->leggiSingolaRiga("geecD_cartelle",$this->id);
            $nomeEscape = filter_var($datiEtichetta["nome"],FILTER_SANITIZE_MAGIC_QUOTES);
            $numeroUtenti = $this->db->contaRigheTabella("geec_utenti",array("etichetta"=>$nomeEscape));
            echo"<div id=\"divEtichetta{$datiEtichetta["id"]}\" class=\"col-sm-6 col-lg-4\">
                <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                        <p class=\"mb-0\"><em><strong>{$datiEtichetta["nome"]}</strong></em>  </p>
                        <small><em>$numeroUtenti utenti</em>  </small>
                    </div>
                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza utenti\" onclick=\"location.href='elencoUtenti.php?etichetta={$datiEtichetta["id"]}';\"><i class=\"fas fa-users\"></i></button>
                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaGruppo({$datiEtichetta["id"]},'$nomeEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                        </div>
                   </div>
                </div>
            </div>";
        }
        
        function alberoCartellaTemplate($aperto = true,$cartellaAttuale=0,$arrayCartelleMadri = []) {
            
            // nell'array delle cartelle madri viene inserita anche la cartella attuale in modo
            // che verrà mostrata nel sottoalbero
            array_push($arrayCartelleMadri,$cartellaAttuale);
            $classeLinkToggle = ($aperto) ? "" : "collapsed";
            $classeDivAlbero  = ($aperto) ? "collapse show" : "collapse";

            ?>
            <div class="dropdownTrigger d-flex align-items-center justify-content-between">
                <a href="impostazioni.php?status=121">
                    Template
                </a>
                <a data-toggle="collapse" class="<?= $classeLinkToggle ?>" href="#alberoCartellaTemplate">
                </a>
            </div>
            <div class="<?= $classeDivAlbero ?>" id="alberoCartellaTemplate">
                <div class="ml-3">
                    <?php 
                        $query = "SELECT * FROM geecD_templateCartelle";
                        $risTemplate = $this->db->eseguiQueryLettura($query);
                        while($templateCartella = $risTemplate->fetch_assoc()) {
                            $queryContenutoCartella = "SELECT * FROM geecD_cartelle WHERE cartellaMadre = {$templateCartella["cartellaCollegata"]}";
                            $risContenutoCartella   = $this->db->eseguiQueryLettura($queryContenutoCartella);

                            if($risContenutoCartella->num_rows>0) {
                                ?>
                                <div class="dropdownTrigger d-flex align-items-center justify-content-between">
                                    <a href="creaTemplateCartelle.php?id=<?= $templateCartella["id"] ?>">
                                        <?= $templateCartella["nome"] ?>
                                    </a>
                                    <a data-toggle="collapse" class="<?= ($cartellaAttuale!=$templateCartella["cartellaCollegata"]) ? "collapsed" : "" ?>" href="#sottoAlbero<?= $templateCartella["id"] ?>">
                                    </a>
                                </div>
                                <div class="collapse <?= (in_array($cartellaAttuale,$arrayCartelleMadri)) ? "show" : "" ?>" id="sottoAlbero<?= $templateCartella["id"] ?>">
                                    <div class="ml-3">
                                        <?php
                                            while($elementoCartella = $risContenutoCartella->fetch_assoc()) {
                                                if(in_array($elementoCartella["id"], $arrayCartelleMadri) || $elementoCartella["id"]==$cartellaAttuale) {
                                                    $this->stampaSottoAlbero($elementoCartella,true,$arrayCartelleMadri);
                                                }
                                                else {
                                                    $this->stampaSottoAlbero($elementoCartella);
                                                }
                                            }
                                        ?>
                                    </div>
                                </div>
                                <?php
                            }
                            else {
                                ?>
                                <a href="creaTemplateCartelle.php?id=<?= $templateCartella["id"] ?>" class=" d-block">
                                    <?= $templateCartella["nome"] ?>
                                </a>
                                <?php
                            }
                        }
                    ?>
                </div>
            </div>
            <?php
        }
        
        /*
         * Restituisce true se la cartella è una sottocartella della cartella template o 
         * ha come radice la cartella template
         */
        function cartellaTemplate() {
            if($this->cartellaRadice()==2) {
                return true;
            }
            else {
                return false;
            }
        }
        
        /*
         * restituisce la cartella radice di una cartella. Risale le cartelle madri
         * fino a restituire la prima cartella madre diversa da 0
         * 
         */
        function cartellaRadice() {
            if($this->cartellaMadre==0) {
                return $this->id;
            }
            else {
                $cartellaMadre = new Cartella($this->db, $this->cartellaMadre);
                $cartellaMadre->caricaDatiDalDatabase();
                return $cartellaMadre->cartellaRadice();
            }
        }
        
        function arrayCartelleMadri() {
            $arrayCartelleMadri = [];
            if($this->cartellaMadre!=0) {
                array_push($arrayCartelleMadri,$this->cartellaMadre);
            }
            
            $cartellaMadre = new Cartella($this->db, $this->cartellaMadre);
            $cartellaMadre->caricaDatiDalDatabase();
            while($cartellaMadre->getCartellaMadre()!=0) {
                array_push($arrayCartelleMadri,$cartellaMadre->getCartellaMadre());
                
                // scendo più in profondita esaminando la cartella madre della cartella madre
                $cartellaMadre = new Cartella($this->db, $cartellaMadre->getCartellaMadre());
                $cartellaMadre->caricaDatiDalDatabase();
            }
            
            return $arrayCartelleMadri;
        }
        
        // getter & setter
        
        function getId() {
            return $this->id;
        }
        
        function getCartellaMadre() {
            return $this->cartellaMadre;
        }

        function getDescrizione() {
            return $this->descrizione;
        }
        
        function getNome() {
            return $this->nome;
        }
        
        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setCartellaMadre($cartellaMadre): void {
            $this->cartellaMadre = $cartellaMadre;
        }
        
        function setNome($nome) {
            $this->nome = $nome;
        }
        
        function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }
        
        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }
    }
